import { world } from "@minecraft/server";

const validEffectTypes = new Set([
    "absorption", "bad_omen", "blindness", "clear", "conduit_power", "darkness",
    "fatal_poison", "fire_resistance", "haste", "health_boost", "hunger",
    "instant_damage", "instant_health", "invisibility", "jump_boost",
    "levitation", "mining_fatigue", "nausea", "night_vision", "poison",
    "regeneration", "resistance", "saturation", "slow_falling", "slowness",
    "speed", "strength", "village_hero", "water_breathing", "weakness", "wither"
]);

const toolEffects = [
    {
        toolTypeId: "v360:emerald_sword",
        effects: [
            { effectType: "regeneration", duration: 2, amplifier: 1, showParticles: true }
        ]
    },
    {
        toolTypeId: "v360:emerald_hoe",
        effects: [
            { effectType: "strength", duration: 2, amplifier: 1, showParticles: true }
        ]
    },
    {
        toolTypeId: "v360:emerald_pickaxe",
        effects: [
            { effectType: "haste", duration: 2, amplifier: 1, showParticles: true }
        ]
    },
    {
        toolTypeId: "v360:emerald_axe",
        effects: [
            { effectType: "speed", duration: 2, amplifier: 1, showParticles: true }
        ]
    },
    {
        toolTypeId: "v360:emerald_shovel",
        effects: [
            { effectType: "water_breathing", duration: 2, amplifier: 0, showParticles: true }
        ]
    }
];

world.afterEvents.entityHitEntity.subscribe(evd => {
    const { damagingEntity, hitEntity } = evd;

    if (damagingEntity.typeId !== 'minecraft:player') return;
    const playerEquippableComp = damagingEntity.getComponent("equippable");
    if (!playerEquippableComp) return;
    const heldItem = playerEquippableComp.getEquipment("Mainhand");
    if (!heldItem) return;
    const foundTool = toolEffects.find(tool => tool.toolTypeId === heldItem.typeId);
    if (foundTool) {
        foundTool.effects.forEach(effectInfo => {
            const { effectType, duration, amplifier, showParticles } = effectInfo;
            if (!validEffectTypes.has(effectType)) return console.error(`§cError:§r §7Invalid effect type '§r${effectType}§7' detected.`);
            const durationInTicks = 20 * duration;
            if (durationInTicks < 1 || durationInTicks > 20000000) return console.error(`§cError:§r §7Duration value '§r${duration}§7' is not within the valid range (0 to 1,000,000 seconds).`);
            if (amplifier < 0 || amplifier > 255) return console.error(`§cError:§r §7Amplifier value '§r${amplifier}§7' is not within the valid range (0 to 255).`);
            if (typeof showParticles !== 'boolean') return console.error(`§cError:§r §7Invalid value '§r${showParticles}§7' for showParticles. It must be a boolean type (true or false).`);


            damagingEntity.addEffect(effectType, durationInTicks, { amplifier, showParticles });
        });
    }
});

world.afterEvents.playerBreakBlock.subscribe(evd => {
    const { player } = evd;

    const playerEquippableComp = player.getComponent("equippable");
    if (!playerEquippableComp) return;
    const heldItem = playerEquippableComp.getEquipment("Mainhand");
    if (!heldItem) return;
    const foundTool = toolEffects.find(tool => tool.toolTypeId === heldItem.typeId);
    if (foundTool) {
        foundTool.effects.forEach(effectInfo => {
            const { effectType, duration, amplifier, showParticles } = effectInfo;
            if (!validEffectTypes.has(effectType)) return console.error(`§cError:§r §7Invalid effect type '§r${effectType}§7' detected.`);
            const durationInTicks = 20 * duration;
            if (durationInTicks < 1 || durationInTicks > 20000000) return console.error(`§cError:§r §7Duration value '§r${duration}§7' is not within the valid range (0 to 1,000,000 seconds).`);
            if (amplifier < 0 || amplifier > 255) return console.error(`§cError:§r §7Amplifier value '§r${amplifier}§7' is not within the valid range (0 to 255).`);
            if (typeof showParticles !== 'boolean') return console.error(`§cError:§r §7Invalid value '§r${showParticles}§7' for showParticles. It must be a boolean type (true or false).`);


            player.addEffect(effectType, durationInTicks, { amplifier, showParticles });
        });
    }
})